/*
 * Decompiled with CFR 0.152.
 */
package pl.amon.moretinygates.gates;

import com.dannyandson.tinygates.RenderHelper;
import com.dannyandson.tinyredstone.blocks.PanelCellNeighbor;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelCellSegment;
import com.dannyandson.tinyredstone.blocks.PanelTileRenderer;
import com.dannyandson.tinyredstone.blocks.Side;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import pl.amon.moretinygates.gates.AbstractAnalogElement;

public class Generator
extends AbstractAnalogElement {
    boolean powerOn = true;
    int level = 0;
    public static ResourceLocation[] TEXTURE_ON = new ResourceLocation[]{new ResourceLocation("moretinygates", "block/generator_on_0"), new ResourceLocation("moretinygates", "block/generator_on_1"), new ResourceLocation("moretinygates", "block/generator_on_2"), new ResourceLocation("moretinygates", "block/generator_on_3"), new ResourceLocation("moretinygates", "block/generator_on_4"), new ResourceLocation("moretinygates", "block/generator_on_5"), new ResourceLocation("moretinygates", "block/generator_on_6"), new ResourceLocation("moretinygates", "block/generator_on_7"), new ResourceLocation("moretinygates", "block/generator_on_8"), new ResourceLocation("moretinygates", "block/generator_on_9"), new ResourceLocation("moretinygates", "block/generator_on_10"), new ResourceLocation("moretinygates", "block/generator_on_11"), new ResourceLocation("moretinygates", "block/generator_on_12"), new ResourceLocation("moretinygates", "block/generator_on_13"), new ResourceLocation("moretinygates", "block/generator_on_14"), new ResourceLocation("moretinygates", "block/generator_on_15")};
    public static ResourceLocation[] TEXTURE_OFF = new ResourceLocation[]{new ResourceLocation("moretinygates", "block/generator_off_0"), new ResourceLocation("moretinygates", "block/generator_off_1"), new ResourceLocation("moretinygates", "block/generator_off_2"), new ResourceLocation("moretinygates", "block/generator_off_3"), new ResourceLocation("moretinygates", "block/generator_off_4"), new ResourceLocation("moretinygates", "block/generator_off_5"), new ResourceLocation("moretinygates", "block/generator_off_6"), new ResourceLocation("moretinygates", "block/generator_off_7"), new ResourceLocation("moretinygates", "block/generator_off_8"), new ResourceLocation("moretinygates", "block/generator_off_9"), new ResourceLocation("moretinygates", "block/generator_off_10"), new ResourceLocation("moretinygates", "block/generator_off_11"), new ResourceLocation("moretinygates", "block/generator_off_12"), new ResourceLocation("moretinygates", "block/generator_off_13"), new ResourceLocation("moretinygates", "block/generator_off_14"), new ResourceLocation("moretinygates", "block/generator_off_15")};

    public void render(PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, float alpha) {
        VertexConsumer builder = buffer.m_6299_((double)alpha == 1.0 ? RenderType.m_110451_() : RenderType.m_110466_());
        TextureAtlasSprite sprite_panel = RenderHelper.getSprite((ResourceLocation)PanelTileRenderer.TEXTURE);
        TextureAtlasSprite sprite_gate = this.powerOn ? RenderHelper.getSprite((ResourceLocation)TEXTURE_ON[this.level]) : RenderHelper.getSprite((ResourceLocation)TEXTURE_OFF[this.level]);
        RenderHelper.drawQuarterSlab((PoseStack)poseStack, (VertexConsumer)builder, (TextureAtlasSprite)sprite_gate, (TextureAtlasSprite)sprite_panel, (int)combinedLight, (float)alpha);
    }

    public boolean neighborChanged(PanelCellPos cellPos) {
        boolean powerOn;
        PanelCellNeighbor back = cellPos.getNeighbor(Side.BACK);
        boolean bl = powerOn = back == null || back.getWeakRsOutput() == 0;
        if (powerOn != this.powerOn) {
            this.powerOn = powerOn;
            this.output = this.powerOn ? this.level : 0;
            return true;
        }
        return false;
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag compoundTag = super.writeNBT();
        compoundTag.m_128379_("powerOn", this.powerOn);
        compoundTag.m_128405_("level", this.level);
        return compoundTag;
    }

    @Override
    public void readNBT(CompoundTag compoundTag) {
        super.readNBT(compoundTag);
        this.powerOn = compoundTag.m_128471_("powerOn");
        this.level = compoundTag.m_128451_("level");
    }

    public boolean onBlockActivated(PanelCellPos cellPos, PanelCellSegment segmentClicked, Player player) {
        ++this.level;
        if (this.level >= 16) {
            this.level = 0;
        }
        if (this.powerOn) {
            this.output = this.level;
        }
        return true;
    }

    public boolean hasActivation() {
        return true;
    }
}

